* This file contains analysis of the GSS
use "Processed files/GSS_micro", clear

egen inc_year=group(faminc year)
xi: oprobit happy i.inc_year [pw=wt_correct]
predict hap_inc, xb

xi: reg faminc i.inc_year [pw=wt_correct]
predict inc, xb
egen t_inc_year=tag(inc_year)
summ hap_inc if t_inc_year==1
replace hap_inc=hap_inc-r(mean)

gen str1 code=""
egen topcode=max(faminc), by(year)
egen bottomcode=min(faminc), by(year)
replace code="T" if faminc==topcode
replace code="B" if faminc==bottomcode

egen nwt=sum(wt*(happy~=.)*(faminc)~=.), by(inc_year)

gen ln_faminc=ln(faminc)

* Regression lines:
reg hap_inc ln_faminc [aw=wt]
predict hap_lninc_hat
global b=string(_b[ln_faminc],"%4.3f")
global a=string(_b[_cons],"%4.3f")
global se=string(_se[ln_faminc],"%4.3f")
reg hap_inc faminc [aw=wt]
predict hap_inc_hat
global b2=string(1000*_b[faminc],"%4.3f")
global a2=string(_b[_cons],"%4.3f")
global se2=string(1000*_se[faminc],"%4.3f")

#delimit ;
twoway
	(scatter hap_inc faminc [fw=nwt], mcolor(navy) msymbol(circle_hollow) msize(small) mlwidth(vvvthin))
	(line hap_lninc_hat faminc, sort lpattern(longdash) lcolor(black) lwidth(medthick))
	(line hap_inc_hat faminc, sort lpattern(shortdash) lcolor(green) lwidth(medthick))
	if t_inc_year==1
,
	title("Log Income Scale")
	xscale(log)
	xtitle("")
	xlabel(1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32" 64000 "64" 128000 "128" 256000 "256")
	ylabel(-1(.5)1, angle(horizontal) format(%9.1f) )
	note("Happiness = $b*log family income [se=$se]", ring(0) pos(5))
	legend(off)
	xsize(10) ysize(7.5)
	name(gss_log, replace)
;
#delimit cr

#delimit ;
twoway
	(scatter hap_inc faminc [fw=nwt], mcolor(navy) msymbol(circle_hollow) msize(small) mlwidth(vvvthin))
	(line hap_lninc_hat faminc, sort lpattern(longdash) lcolor(black) lwidth(medthick))
	(line hap_inc_hat faminc, sort lpattern(shortdash) lcolor(green) lwidth(medthick))
	if t_inc_year==1
,
	title("Linear Income Scale")
	xtitle("")
	xlabel(0 "0" 40000 "40" 80000 "80" 120000 "120" 160000 "160" 200000 "200" 240000 "240")
	ylabel(-1(.5)1, angle(horizontal) format(%9.1f) )
	note("Happiness = $b2*family income in thousands [se=$se2]", ring(0) pos(5))
	legend(off)
	xsize(10) ysize(7.5)
	name(gss_linear, replace)
;
#delimit cr

#delimit ;
graph combine gss_linear gss_log ,
	ycommon
	rows(1)
	imargin(tiny)
	b2title("Annual family income (thousands of 2005 dollars)", size(small))
	l1title("Happiness (ordered probit index)", size(small))
	name(fig8, replace)
	xsize(10) ysize(7.5)
;
#delimit cr
graph save "Figures/fig8.gph", replace

*** Figure 13
use "Processed files\GSS_macro", clear
sort year
merge year using "GDP\US data.dta" 
drop if _merge==2
drop _merge

replace lny_us_gap=lny_us_gap*100

reg hap_hat lny_us_gap
cap predict hap_hat_r, res
local b=string(_b[lny_us_gap],"%4.3f")
local a=string(_b[_cons],"%3.2f")
local se=string(_se[lny_us_gap],"%4.3f")
correl hap_hat lny_us_gap
local rho=string(r(rho),"%3.2f")

#delimit ;
twoway
	(line lny_us_gap year, sort lpattern(dash) lcolor(green))
	(line hap_hat year, sort yaxis(2) lcolor(navy))
,
	ytitle("Output gap, percent of GDP")
	ylabel(-4(2)4, angle(horizontal))
	ytitle("Happiness (ordered probit index)", axis(2))
	ylabel(-0.10(0.05)0.10, axis(2) angle(horizontal) format(%9.2f))
	text(-2 1999  "Happiness" "(right axis)", color(navy))
	text(2 2000 "Output gap (left axis)", color(green))
	xtitle("")
	xlabel(1972(4)2008)
	note("Happiness = `a'+`b'*Output gap (se=`se')" "Correlation=`rho'", ring(0) pos(5))
	legend(off)
	xsize(10) ysize(7.5)
;
#delimit cr
graph save "Figures\fig13.gph", replace


*** Figure 20
gen y=exp(lny_us)
gen lav_hh_inc=ln(av_hh_inc)
gen lav_REALINC=ln(REALINC)
for X in var lav_hh_inc lny_us lav_REALINC: gen X_1972=X if year==1972 \ tomode X_1972, replace \ gen X_ch=X-X_1972 \ drop X_1972

gen av_ln_hh_inc=ln(av_hh_inc)-mld
gen mld_gss=lav_REALINC-lREALINC
for X in var lREALINC av_ln_hh_inc mld mld_gss: gen X_1972=X if year==1972 \ tomode X_1972, replace \ gen X_ch=X-X_1972 \ drop X_1972

#delimit ;
twoway
	(connected hap_hat year, lcolor(black) yaxis(1) msymbol(diamond) mcolor(black))
	(lfit hap_hat year, lcolor(black) yaxis(1) lpattern(longdash) lwidth(vvthin))
,
	title("Average Happiness (GSS)", ring(0))
	ytitle("Ordered probit index" " ")
	ylabel(-.2(.1).2, angle(horizontal) format(%9.1f) )
	xtitle("")
	xlabel(1972(4)2008, nolabel)
	legend(off)
	name(inc1, replace)
;
#delimit ;

#delimit ;
twoway
	(line lny_us_ch year, sort lcolor(green))
	(lfit lny_us_ch year, sort lcolor(green) lpattern(longdash) lwidth(vvvthin))
	(line lav_hh_inc_ch year, sort lcolor(navy))
	(lfit lav_hh_inc_ch year, sort lcolor(navy) lpattern(longdash) lwidth(vvvthin))
	(line lav_REALINC_ch year, sort lcolor(cranberry))
	(lfit lav_REALINC_ch year, sort lcolor(cranberry) lpattern(longdash) lwidth(vvvthin))

,
	title("Logarithm of average income", ring(0))
	ytitle("Cumulative change since 1972" "(log points)")
	ylabel(-0.2(0.2)0.8, angle(horizontal) format(%9.1f))
	xtitle("")
	xlabel(1972(4)2008, nolabel)
	text(.35 2007 "Household" "income" "(CPS)", color(navy) size(medsmall))
	text(.66 2008 "GDP per" "capita", color(green) size(medsmall))
	text(.0 2002 "Family" "income" "(GSS)", color(cranberry) size(medsmall))
	xsize(10) ysize(7.5)
	legend(off)
	name(inc2, replace)
;
#delimit cr


#delimit ;
twoway
	(line av_ln_hh_inc_ch year, sort lcolor(navy))
	(lfit av_ln_hh_inc_ch year, sort lcolor(navy) lpattern(longdash) lwidth(vvvthin))
	(line lREALINC_ch year, sort lcolor(cranberry))
	(lfit lREALINC_ch year, sort lcolor(cranberry) lpattern(longdash) lwidth(vvvthin))

,
	title("Average of logarithm of income", ring(0))
	ytitle("Cumulative change since 1972" "(log points)")
	ylabel(-0.2(0.2)0.8, angle(horizontal) format(%9.1f))
	xtitle("")
	xlabel(1972(4)2008)
	text(.2 2007.3 "Household" "income" "(CPS)", color(navy) size(medsmall) )
	text(-.1 2002 "Family" "income" "(GSS)",  color(cranberry) size(medsmall))
	xsize(10) ysize(7.5)
	legend(off)
	name(inc3, replace)
;
#delimit cr

#delimit ;
graph combine inc1 inc2 inc3
	,
	rows(3)
	xcommon
	imargin(tiny)
	xsize(7.5) ysize(10)
	name(fig20, replace)
;
#delimit cr
graph save "Figures/fig20.gph", replace


